//=====================================================================================
//
//	Author				:Cytron Technologies		
//	Project				:control pwm
//	Project description	:control PWM chip using PIC18F4520 
//
//=====================================================================================

#include<p18f4520.h>

//=====================================================================================
//	configuration bit
//=====================================================================================
#pragma config OSC = HS
#pragma config FCMEN = OFF 
#pragma config IESO = OFF 
#pragma config PWRT = OFF 
#pragma config BOREN = OFF 
#pragma config WDT = OFF 
#pragma config MCLRE = ON	
#pragma config PBADEN = OFF 
#pragma config DEBUG = OFF
#pragma config XINST = OFF
#pragma config LVP = OFF 

//=====================================================================================
//	define input or ouput of board here
//	
//=====================================================================================

#define	button1		PORTBbits.RB0			//button 1 active low
#define	select1		LATBbits.LATB3			//led1 active high				
#define	select2		LATBbits.LATB2			//led2 active high				
#define	select3		LATBbits.LATB1			//led3 active high
#define reset		LATBbits.LATB7			//reset of PWM chip, 0=reset, normally high

//=====================================================================================
//	function prototype
//=====================================================================================
void ISRHigh(void);
void ISRLow(void);
void delay(unsigned long data);
void init(void);
unsigned char read_serial(void);
void send_serial(unsigned char data);
void send_dec(unsigned long data,unsigned char num_dig);
void UART9600(void);		
void spi_init(void);
unsigned char spi_receive(void);
void spi_send(unsigned char data);
void WritePWM_SPI(unsigned char channel, unsigned char value);

//=====================================================================================
//	Global Variable
//=====================================================================================

//=====================================================================================
// protocol for data send to PWM chip
//=====================================================================================
// data1 = channel of PWM

//=====================================================================================
//	Main Function
//	This is the main function where program start to execute 
//=====================================================================================

void main(void)
{	

	unsigned short data_temp1;

	init();					// call initialization function of the setting in program

	reset = 0;
	delay(5000);			//14ms
	reset=1;
	select1 = 0;
	select2 = 0;
	select3 = 0;


	while(1)
	{	
		if(button1==0)					//button 1 to switch mode between play and record
		{	
			while(button1==0);			//wait button 1 to release
				
			PORTC = 0;	
			spi_init();				
			UART9600();
			reset = 0;					// reset Multi PWM chip			
			delay(5000);
			reset = 1;
			select1 = 1;
			select2 = 1;
			select3 = 0;
			delay(10);					//delay 29us for the PWM chip to switch to selected mode
			WritePWM_SPI(0x00,0xf0);
			WritePWM_SPI(0x01,0x0f);
				
			WritePWM_SPI('R',0x00);
			data_temp1=spi_receive();		
			send_dec(data_temp1,3);
			
			WritePWM_SPI(0x04,0x0f);
			WritePWM_SPI(0x07,0x1f);
			
				
			WritePWM_SPI('R',0x07);
			data_temp1=spi_receive();
			send_dec(data_temp1,3);
		}
	}
	
}

//=====================================================================================
//	functions
//  User can write all the necessary function here
//=====================================================================================
//read uart data
unsigned char read_serial(void)
{
	unsigned char temp;
	while(PIR1bits.RCIF==0);
	temp=RCREG;
	return temp;
}

//send uart data
void send_serial(unsigned char data)
{
	while (PIR1bits.TXIF == 0);
	TXREG = data;	
}

void send_dec(unsigned long data,unsigned char num_dig)
{
	
	if(num_dig>=10)
	{
		data=data%10000000000;
		send_serial(data/1000000000+0x30);
	}	
	if(num_dig>=9)
	{
		data=data%1000000000;
		send_serial(data/100000000+0x30);
	}	
	if(num_dig>=8)
	{
		data=data%100000000;
		send_serial(data/10000000+0x30);
	}	
	if(num_dig>=7)
	{
		data=data%10000000;
		send_serial(data/1000000+0x30);
	}	
	if(num_dig>=6)
	{
		data=data%1000000;
		send_serial(data/100000+0x30);
	}	
	if(num_dig>=5)
	{
		data=data%100000;
		send_serial(data/10000+0x30);
	}	
	if(num_dig>=4)
	{
		data=data%10000;
		send_serial(data/1000+0x30);
	}
	if(num_dig>=3)
	{
		data=data%1000;
		send_serial(data/100+0x30);
	}
	if(num_dig>=2)
	{
		data=data%100;
		send_serial(data/10+0x30);
	}
	if(num_dig>=1)
	{
		data=data%10;
		send_serial(data+0x30);
	}
}


void delay(unsigned long data)
{
	for( ;data>0;data-=1);
}

void UART9600(void)
{
	unsigned char temp;

	//initialize uart	
	TRISCbits.TRISC6=1;					//TX
	TRISCbits.TRISC7=1;					//RX
	SPBRG = 64;		   	// default as 9600, Fosc = 32M, [8M,51] [32M,208][10M, 64][40M,260]

	TXSTAbits.TX9=0;		//8/9-bit transmission, 0 = 8bit, 1=9bit
	TXSTAbits.TXEN=1;		//disable/enable transmit
	TXSTAbits.SYNC=0;		//asynchronous/synchronous mode, 0 =asyn

	TXSTAbits.BRGH=1;		//low/high speed, 1 = high speed,0, SPBRG=Fosc/(64*baud)-1, 9600=15.27, 57600=1.7

	RCSTAbits.SPEN=1;		//serial port disable/enable
	RCSTAbits.RX9=0;		//8/9-bit reception, 0 =8bit
	RCSTAbits.CREN=1;		//continuous receive disable/enable

	BAUDCON = 0b00000000;	//BAUD RATE CONTROL REGISTER
	temp=RCREG;				//clear receive buffer
	temp=RCREG;

	PIR1bits.RCIF=0;		//clear interrupt flag
	PIE1bits.RCIE=0;		//disable/enable receive interrupt
	IPR1bits.RCIP=0;		//low/high priority interrupt
	
}

void init(void)
{

	// this is a initialization for set the input and output of PIC18F4520
	// tris
	TRISB=0x01;				// portB as output, RB0 as input
	TRISD=0x00;				// portD as output
	TRISC=0xff;				// 
	
	select1 = 0;
	select2 = 0;
	select3 = 0;
	
}

//SPI initialization
void spi_init(void)
{
	TRISCbits.TRISC3=0;		//SCK, clear in master mode
	TRISCbits.TRISC5=0;		//SDO

	TRISBbits.TRISB4=0;		// RB4 connect to RC2 at PWM chip, SS control,
							// SS(RA4) in PWM chip used as analog pin
	TRISCbits.TRISC4=1;		//SCK, clear in master mode
	
	SSPSTATbits.SMP=0;		//data sampled at middle
	SSPSTATbits.CKE=0;		//positive edge

	SSPCON1bits.WCOL=0;		//write collision bit
	SSPCON1bits.SSPOV=0;	//receive overflow bit

	SSPCON1bits.CKP=0;		//Clock Polarity Select bit,Idle state for clock is a low level & high in active state
	
	SSPCON1bits.SSPM3=0;	//SPI mode
	SSPCON1bits.SSPM2=0;
	SSPCON1bits.SSPM1=1;
	SSPCON1bits.SSPM0=0;   //0010 = SPI Master mode, clock = Fosc/64
	
	SSPCON1bits.SSPEN=1;	//enable SDO,SDI, SCK and SS as serial pin
	PIE1bits.SSPIE=0;		//interrupt enable
	IPR1bits.SSPIP=0;		//interrupt priority
	PIR1bits.SSPIF=0;		//interrupt flag		
}

unsigned char spi_receive(void)
{
	// Send the dummy data
	SSPBUF = 0xff;
	
	// Wait for the SPI module to finish sending / receiving.
	while(SSPSTATbits.BF == 0);
	
	// Return the received data.
	return SSPBUF;
}

void spi_send(unsigned char data)
{
	unsigned char buffer;
	// Send the data
	SSPBUF = data;
	
	// Wait for the SPI module to finish sending / receiving.
	while(SSPSTATbits.BF == 0);

	// Read the received data
	buffer = SSPBUF;
}


void WritePWM_SPI(unsigned char channel, unsigned char value)
{
	spi_send(channel);
	spi_send(value);
}

//=====================================================================================
//	Interrupt vector
//=====================================================================================
#pragma	code InterruptVectorHigh = 0x08
void InterruptVectorHigh(void)
{
 	_asm
		goto ISRHigh		// jump to interrupt routine
	_endasm
}
#pragma code

#pragma	code InterruptVectorLow = 0x18
void InterruptVectorLow(void)
{
 	_asm
		goto ISRLow			// jump to interrupt routine
	_endasm
}
#pragma code

//=====================================================================================
//	Interupt Service Routine
//	this a function reserved for interrupt service routine
//=====================================================================================
#pragma interrupt ISRHigh
void ISRHigh(void)
{

	
}

#pragma interrupt ISRLow
void ISRLow(void)
{
	
}
